 /**
* \file: FeatureDiscoveryDefines.h
*
* \version: 0.1
*
* \release: $Name:$
*
* Includes all defines which a necessary to execute the vendor request.
*
* \component: Unified SPI
*
* \author: D. Girnus / ADIT/SW2 / dgirnus@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef USPI_FEATURE_DISCOVERY_DEFINES_H_
#define USPI_FEATURE_DISCOVERY_DEFINES_H_


/* include only to use LIBUSB_ENDPOINT_IN, LIBUSB_ENDPOINT_OUT, LIBUSB_REQUEST_TYPE_VENDOR */
#include <libusb-1.0/libusb.h>


namespace adit { namespace uspi {


/* LIBUSB_ENDPOINT_IN (0x80) | LIBUSB_REQUEST_TYPE_VENDOR (0x02 << 5) = 0xC0 */
#define REQ_TYPE_USB_DEVICE_TO_HOST                 LIBUSB_ENDPOINT_IN | LIBUSB_REQUEST_TYPE_VENDOR
/* LIBUSB_ENDPOINT_OUT (0x00) | LIBUSB_REQUEST_TYPE_VENDOR (0x02 << 5) = 0x40 */
#define REQ_TYPE_USB_HOST_TO_DEVICE                 LIBUSB_ENDPOINT_OUT | LIBUSB_REQUEST_TYPE_VENDOR


/* vendor request to get_supported AOA protocol version */
#define REQ_AOAP_GET_PROTOCOL                       0x33  // 51[dec]

#define VALUE_AOAP_GET_PROTOCOL                     0x00
#define INDEX_AOAP_GET_PROTOCOL                     0x00

/* DATA_AOAP_GET_PROTOCOL:        16 bits little endian sent from the device to the accessory */
/* DATA_LEN_AOAP_GET_PROTOCOL:    2 bytes */


/* vendor request to identifying string information */
#define REQ_AOAP_STRING_INFORMATION                 0x34  // 52[dec]

#define VALUE_AOAP_STRING_INFORMATION               0x00
#define INDEX_AOAP_STRING_MANUFACURER               0x00
#define INDEX_AOAP_STRING_MODEL_NAME                0x01
#define INDEX_AOAP_STRING_DESCRIPTION               0x02
#define INDEX_AOAP_STRING_VERSION                   0x03
#define INDEX_AOAP_STRING_URI                       0x04
#define INDEX_AOAP_STRING_SERIAL                    0x05

/* DATA_AOAP_STRING_INFORMATION:        zero terminated UTF8 string sent from accessory to device */
/* DATA_LEN_AOAP_STRING_INFORMATION:    length of string */


/* vendor request to start device in accessory mode */
#define REQ_AOAP_START                              0x35  // 53[dec]

#define VALUE_AOAP_START                            0x00
#define INDEX_AOAP_START                            0x00

#define DATA_AOAP_START                             NULL
#define DATA_LEN_AOAP_START                         0x00


#define REQ_AOAP_ENABLE_AUDIO                       0x3A // 58[dec]


/* vendor request to check for CarPlay support */
#define REQ_APPLE_GET_CAPABILITIES                  0x53  // 83[dec]

#define VALUE_APPLE_GET_CAPABILITIES                0x00
#define INDEX_APPLE_GET_CAPABILITIES                0x00

/* DATA_APPLE_GET_CAPABILITIES:        16 bits little endian bitfield + 16 bits little endian value */
/* DATA_LEN_APPLE_GET_CAPABILITIES:    4 bytes */


/* vendor request to request USB Role Switch */
#define REQ_APPLE_USB_ROLE_SWITCH                   0x51  // 81[dec]
/* obsolete: old vendor request to request USB Role Switch */
#define REQ_APPLE_USB_ROLE_SWITCH_OLD               0x50  // 80[dec]

#define VALUE_APPLE_START_CARPLAY                   0x01
#define INDEX_APPLE_START_CARPLAY                   0x00  // reserved

#define DATA_APPLE_START_CARPLAY                    NULL
#define DATA_LEN_APPLE_START_CARPLAY                0x00

#define VALUE_APPLE_START_NATIVE_HOST_MODE          0x00
#define INDEX_APPLE_START_NATIVE_HOST_MODE          0x00

#define DATA_APPLE_START_NATIVE_HOST_MODE           NULL
#define DATA_LEN_APPLE_START_NATIVE_HOST_MODE       0x00


/* vendor request to request start MirrorLink */
#define REQ_MIRRORLINK_START                        0xF0  // 240[dec]

#define VALUE_MIRRORLINK_START                      0x0101  // MirrorLink 1.1
#define INDEX_MIRRORLINK_START                      0x00

#define DATA_MIRRORLINK_START                       NULL
#define DATA_LEN_MIRRORLINK_START                   0x00


#define FD_APPLE_VENDOR_ID             0x05AC
#define FD_APPLE_PRODUCT_ID_MIN        0x1200


} } /* namespace adit { namespace uspi { */


#endif /* USPI_FEATURE_DISCOVERY_DEFINES_H_ */
